<?php
require('fpdf/fpdf.php');

// Include database connection file
require_once 'db.php';

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve form data
    $registerNumber = $_POST['registerNumber'];
    $name = $_POST['name'];
    $degree = $_POST['degree'];
    $stream = $_POST['stream'];
    $classDepartment = $_POST['class-department'];
    $address = $_POST['address'];
    $mobile = $_POST['mobile'];
    $email = $_POST['email'];
    $fathersName = $_POST['fathers-name'];
    $fathersOccupation = $_POST['fathers-occupation'];
    $mothersName = $_POST['mothers-name'];
    $mothersOccupation = $_POST['mothers-occupation'];
    $guardianName = $_POST['guardian-name'];
    $guardianOccupation = $_POST['guardian-occupation'];
    $annualIncome = $_POST['annual-income'];
    $contactNumber = $_POST['contact-number'];
    $reason = $_POST['reason'];

    // Handle siblings data
    $siblingNames = $_POST['sibling-name'];
    $siblingStatuses = $_POST['sibling-status'];
    $siblingEmployments = $_POST['sibling-employment'];

    // Handle uploaded photo
    $photo = $_FILES['photo']['name']; // The filename of the uploaded photo
    $photoTmpName = $_FILES['photo']['tmp_name']; // Temporary file name
    $photoPath = 'uploads/' . $photo; // Define the path to save the photo
    move_uploaded_file($photoTmpName, $photoPath); // Move the uploaded file to the defined path

    // Check if preview button is clicked
    if (isset($_POST['download'])) {
        // Create PDF
        $pdf = new FPDF();
        $pdf->AddPage();
        $pdf->SetFont('Times', '', 12);

        // Add logo
        $pdf->Image('./img/logo.jpg', 10, 10, 25);

        // Add uploaded photo at the top right
        $pdf->Image($photoPath, 160, 10, 30); // Adjust the position and size as needed

        $pdf->Ln(6); // Reduced line break

        // Add heading at the top center with reduced line spacing
        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell(0, 6, 'MADRAS CHRISTIAN COLLEGE (AUTONOMOUS)', 0, 1, 'C');
        $pdf->Cell(0, 6, 'TAMBARAM, CHENNAI - 600 059', 0, 1, 'C');
        $pdf->Cell(0, 6, 'CENTRE FOR WOMEN\'S STUDIES', 0, 1, 'C');
        $pdf->Cell(0, 6, 'MANNA SCHEME 2024-2025', 0, 1, 'C');
        $pdf->Ln(10); // Reduced line break

        // Add form details with reduced line spacing
        $pdf->SetFont('Times', 'B', 12);
        $labelWidth = 50; // Adjust as needed
        $valueX = $labelWidth + 10; // Position for values

        $pdf->Cell($labelWidth, 8, 'Register Number:', 0, 0);
        $pdf->SetX($valueX);
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 8, $registerNumber, 0, 1);
        $pdf->SetFont('Times', 'B', 12);

        $pdf->Cell($labelWidth, 8, 'Name:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $name, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Degree:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $degree, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Stream:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $stream, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Class & Department:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $classDepartment, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Address:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->MultiCell(0, 8, $address);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Mobile:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $mobile, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Email:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $email, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Father\'s Name:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $fathersName, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Father\'s Occupation:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $fathersOccupation, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Mother\'s Name:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $mothersName, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Mother\'s Occupation:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $mothersOccupation, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Guardian\'s Name:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $guardianName, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Guardian\'s Occupation:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $guardianOccupation, 0, 1);

        // Add siblings details
        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Sibling Details:', 0, 1);
        $pdf->SetFont('Times', '', 12);
        foreach ($siblingNames as $index => $siblingName) {
            $pdf->SetFont('Times', 'B', 12);
            $pdf->Cell($labelWidth, 8, 'Sibling Name:', 0, 0);
            $pdf->SetFont('Times', '', 12);
            $pdf->Cell(0, 8, $siblingNames[$index], 0, 1);
            $pdf->SetFont('Times', 'B', 12);
            $pdf->Cell($labelWidth, 8, 'Sibling Status:', 0, 0);
            $pdf->SetFont('Times', '', 12);
            $pdf->Cell(0, 8, $siblingStatuses[$index], 0, 1);
            $pdf->SetFont('Times', 'B', 12);
            $pdf->Cell($labelWidth, 8, 'Sibling Employment:', 0, 0);
            $pdf->SetFont('Times', '', 12);
            $pdf->Cell(0, 8, $siblingEmployments[$index], 0, 1);
            $pdf->Ln(2); // Reduced space between sibling entries
        }

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Annual Income:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $annualIncome, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Contact Number:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->Cell(0, 8, $contactNumber, 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Reason:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetX($valueX);
        $pdf->MultiCell(0, 8, $reason);
        
        $pdf->Ln(8); // Reduced line break for signatures

        // Add Signature and Date fields on the left side
        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Signature:                                                                          Recommended by Head of the Department', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 8, '', 0, 1);
        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Date:                                                                                   Signature:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 8, '', 0, 1);

        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, '                                                                                            Date:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 8, '', 0, 1);
        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Contact:', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 8, '', 0, 1);
        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell(0, 8, 'Dr.PHEBE ANGUS G (Aided)      -        9600099681', 0, 0);
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 8, '', 0, 1);
        $pdf->SetFont('Times', 'B', 12);
        $pdf->Cell($labelWidth, 8, 'Prof D RAMALA SINGH(SFS)     -        9840133196', 0, 0);

        // Output PDF
        $pdf->Output();
    }
}
?>
