document.addEventListener('DOMContentLoaded', function () {
    const classDepartmentSelect = document.getElementById('class-department');
    const streamRadios = document.querySelectorAll('input[name="stream"]');
    const degreeRadios = document.querySelectorAll('input[name="degree"]');
    let selectedStream = '';
    let selectedDegree = '';
    const addSiblingButton = document.getElementById('add-sibling');
    const siblingSection = document.querySelector('.siblings-section');
    const siblingTemplate = siblingSection.cloneNode(true);
    // Handle Preview Button Click
    const previewButton = document.querySelector('button[name="preview"]');
    previewButton.addEventListener('click', function () {
        const previewContent = document.getElementById('previewContent');
        previewContent.innerHTML = ''; // Clear existing content

        const formData = new FormData(document.getElementById('application-form'));
        formData.forEach((value, key) => {
            const row = document.createElement('tr');
            const keyCell = document.createElement('td');
            const valueCell = document.createElement('td');

            keyCell.textContent = formatLabel(key);
            valueCell.textContent = value;

            row.appendChild(keyCell);
            row.appendChild(valueCell);
            previewContent.appendChild(row);
        });

        $('#previewModal').modal('show');
    });

    function formatLabel(key) {
        return key.replace(/-/g, ' ').replace(/\b\w/g, char => char.toUpperCase());
    }

    streamRadios.forEach(radio => {
        radio.addEventListener('change', function () {
            selectedStream = this.value;
            updateClassDepartmentOptions();
        });
    });

    degreeRadios.forEach(radio => {
        radio.addEventListener('change', function () {
            selectedDegree = this.value;
            updateClassDepartmentOptions();
        });
    });

    addSiblingButton.addEventListener('click', function () {
        const newSiblingSection = siblingTemplate.cloneNode(true);
        siblingSection.parentNode.insertBefore(newSiblingSection, siblingSection.nextSibling);
    });

    function updateClassDepartmentOptions() {
        classDepartmentSelect.innerHTML = ''; // Clear existing options

        let options = [];
        if (selectedStream === 'Aided') {
            if (selectedDegree === 'UG') {
                options = [
                    'B. A. English Language and Literature',
                    'B. A. Tamil Literature',
                    'B. A. History',
                    'B. A. Political Science',
                    'B. A. Economics',
                    'B. A. Philosophy',
                    'B. Com. – Commerce',
                    'B. Sc. Mathematics',
                    'B. Sc. Statistics',
                    'B. Sc. Physics',
                    'B. Sc. Chemistry',
                    'B. Sc. Plant Biology and Plant Biotechnology',
                    'B. Sc. Zoology'
                ];
            } else if (selectedDegree === 'PG') {
                options = [
                    'M. A. English Language and Literature',
                    'M. A. Tamil Literature',
                    'M. A. History',
                    'M. A. Political Science',
                    'M. A. Public Administration',
                    'M. A. Economics',
                    'M. A. Philosophy',
                    'M. Com. – Commerce',
                    'M. S. W. (Community Development & Medical Psychiatry)',
                    'M. Sc. Mathematics',
                    'M. Sc. Statistics',
                    'M. Sc. Physics',
                    'M. Sc. Chemistry',
                    'M. Sc. Plant Biology and Plant Biotechnology',
                    'M. Sc. Zoology'
                ];
            } else if (selectedDegree === 'Research Programme') {
                options = [
                    'English',
                    'Tamil',
                    'History',
                    'Political Science',
                    'Public Administration',
                    'Economics',
                    'Philosophy',
                    'Commerce',
                    'Mathematics',
                    'Statistics',
                    'Physics',
                    'Chemistry',
                    'Botany',
                    'Zoology',
                    'Telugu (Part-Time)',
                    'Social Work (Part-Time)'
                ];
            }
        } else if (selectedStream === 'SFS') {
            if (selectedDegree === 'UG') {
                options = [
                    'B. A. English Language and Literature',
                    'B. A. Journalism',
                    'B. A. History (Vocational)– (Archeology and Museology) – (Shift I)',
                    'B. S. W. Social Work',
                    'B. Com. – Commerce',
                    'B. Com. Accounting and Finance',
                    'B. Com. Professional Accounting',
                    'B. B. A. Business Administration',
                    'B. Sc. Geography, Tourism and Travel Management',
                    'B. Sc. Hospitality and Tourism',
                    'B. Sc. Mathematics',
                    'B. Sc. Physics',
                    'B. Sc. Microbiology',
                    'B. C. A. Computer Application',
                    'B. Sc. Computer Science',
                    'B. Sc. Visual Communication',
                    'B. Sc. Physical Education, Health Education and Sports',
                    'B. Sc. Psychology'
                ];
            } else if (selectedDegree === 'PG') {
                options = [
                    'M. S. W. Social Work (Human Resource Management)',
                    'M. Com. Computer Oriented Business Application',
                    'M. A. Communication',
                    'M. Sc. Chemistry',
                    'M. Sc. Applied Microbiology',
                    'M. C. A.  Computer Application',
                    'M. Sc. Data Science (Provisional)'
                ];
            } else if (selectedDegree === 'Research Programme') {
                options = [
                    'Microbiology',
                    'Commerce (Part-Time)',
                    'Social Work (Part-Time)'
                ];
            }
        }

        options.forEach(option => {
            const opt = document.createElement('option');
            opt.value = option;
            opt.text = option;
            classDepartmentSelect.add(opt);
        });

        
    }

    

    
});
