<?php
// Check if the user is logged in by checking the cookie
if (!isset($_COOKIE['loggedin']) || $_COOKIE['loggedin'] !== 'true') {
    // If the cookie is not set or is not valid, redirect to the login page
    header("Location: login.php");
    exit;
}

require_once 'db.php';

$fullName = "";
$data = null;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $fullName = $_POST['full_name'];

    // Query to fetch the details based on full name
    $query = "
    SELECT 
    a.full_name, a.email, a.contact_number, a.dob, a.university_name, 
    a.degree_program, a.year_of_study, a.department, a.skills, a.interests,
    a.hackathon_experience, a.project_experience, a.participation_reason, 
    a.how_did_you_hear, a.resume, a.created_at, a.projectidea
    FROM 
    applications a
    WHERE a.full_name = ?
    ";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $fullName);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();

    $stmt->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <title>TTSkill-Search</title>
    <link href="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/style.min.css" rel="stylesheet" />
    <link href="css/styles.css" rel="stylesheet" />
    <script src="https://use.fontawesome.com/releases/v6.3.0/js/all.js" crossorigin="anonymous"></script>
</head>
<body class="sb-nav-fixed">
    <?php require_once 'topbar.html' ?>
    <div id="layoutSidenav">
        <div id="layoutSidenav_nav">
            <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">
                        <div class="sb-sidenav-menu-heading">Menu</div>
                        <a class="nav-link" href="dashboard.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Dashboard
                        </a>
                        <a class="nav-link" href="search.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-search"></i></div>
                            Search
                        </a>
                        <a class="nav-link" href="tables.php">
                            <div class="sb-nav-link-icon"><i class="fas fa-table"></i></div>
                            Database
                        </a>                         
                    </div>
                </div>
                <div class="sb-sidenav-footer">
                    <div class="small">Logged in as:</div>
                    TTSkill-Admin
                </div>
            </nav>
        </div>
        <div id="layoutSidenav_content">
            <main>
                <div class="container-fluid px-4">
                    <div class="container mt-5">
                        <h1 class="mb-4">Search Application</h1>
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                            <li class="breadcrumb-item active">Search</li>
                        </ol>
                        <form method="post" id="searchForm">
                            <div class="form-group">
                                <label for="full_name">Enter Full Name:</label>
                                <input type="text" class="form-control" id="full_name" name="full_name" value="<?php echo htmlspecialchars($fullName); ?>" required>
                            </div>
                            <button type="submit" class="btn btn-primary mt-3">Search</button>
                        </form>

                        <?php if ($data): ?>
                            <div class="mt-5">
                                <h3>Application Details</h3>
                                <table class="table table-bordered table-striped">
                                    <tbody>
                                        <tr>
                                            <th>Full Name</th>
                                            <td><?php echo htmlspecialchars($data['full_name']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td><?php echo htmlspecialchars($data['email']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Contact Number</th>
                                            <td><?php echo htmlspecialchars($data['contact_number']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Date of Birth</th>
                                            <td><?php echo htmlspecialchars($data['dob']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>University Name</th>
                                            <td><?php echo htmlspecialchars($data['university_name']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Degree Program</th>
                                            <td><?php echo htmlspecialchars($data['degree_program']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Year of Study</th>
                                            <td><?php echo htmlspecialchars($data['year_of_study']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Department</th>
                                            <td><?php echo htmlspecialchars($data['department']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Skills</th>
                                            <td><?php echo htmlspecialchars($data['skills']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Interests</th>
                                            <td><?php echo htmlspecialchars($data['interests']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Project Idea</th>
                                            <td><?php echo htmlspecialchars($data['projectidea']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Hackathon Experience</th>
                                            <td><?php echo htmlspecialchars($data['hackathon_experience']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Project Experience</th>
                                            <td><?php echo htmlspecialchars($data['project_experience']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Participation Reason</th>
                                            <td><?php echo htmlspecialchars($data['participation_reason']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>How Did You Hear</th>
                                            <td><?php echo htmlspecialchars($data['how_did_you_hear']); ?></td>
                                        </tr>
                                        <tr>
                                            <th>Resume</th>
                                            <td><a href="uploads/<?php echo htmlspecialchars($data['resume']); ?>" target="_blank">View Resume</a></td>
                                        </tr>
                                        <tr>
                                            <th>Created At</th>
                                            <td><?php echo htmlspecialchars($data['created_at']); ?></td>
                                        </tr>                                        
                                    </tbody>
                                </table>
                            </div>
                        <?php elseif ($_SERVER["REQUEST_METHOD"] == "POST"): ?>
                            <div class="mt-3">
                                <div class="alert alert-danger">No data found for Full Name: <?php echo htmlspecialchars($fullName); ?></div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
            <footer class="py-4 bg-light mt-auto">
                <div class="container-fluid px-4">
                    <div class="d-flex align-items-center justify-content-between small">
                        <div class="text-muted">Copyright &copy; Madras Christian College 2024</div>
                        <div>
                            <a href="#">Privacy Policy</a>
                            &middot;
                            <a href="#">Terms & Conditions</a>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js"></script>
    <script src="js/scripts.js"></script>
</body>
</html>
